/****** Object:  StoredProcedure [dbo].[P_GLB_DT_MOVIMENTO_CRIAR_CALENDARIO]    Script Date: 06/28/2012 17:11:11 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GLB_DT_MOVIMENTO_CRIAR_CALENDARIO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GLB_DT_MOVIMENTO_CRIAR_CALENDARIO]
GO
GO
--EXEC P_GLB_DT_MOVIMENTO_CRIAR_CALENDARIO
CREATE PROCEDURE P_GLB_DT_MOVIMENTO_CRIAR_CALENDARIO (@DataIni datetime='2015-01-01',@dataFim datetime='2020-01-01')
AS
create table #RsCalendario(Dt datetime,
						   Mes int,
						   Ano int,
						   Trimestre int,
						   DiaSemana int,
						   Dia int,
						   AnoSemana int,
						   DiaNome varchar(50))
declare @start datetime,
@end datetime
set @start = @DataIni
set @end = @dataFim
;with calendar(date, m,y, q,dw,d,W) as
(
select @start ,
datepart(mm,@start),
year(@start),
datepart(qq,@start),
datepart(dw,@start),
datepart(dd,@start),
datepart(wk, @start)
union all
select date + 1,
datepart(mm,date + 1),
year(date + 1),
datepart(qq,date + 1),
datepart(dw,date + 1),
datepart(dd,date + 1),
datepart(wk, date + 1)
from calendar where date + 1< @end
)
insert into
#RsCalendario
(Dt,
Mes,
Ano,
Trimestre,
DiaSemana,
Dia,
AnoSemana
)
select 
	* 
from calendar option(maxrecursion 10000)

update
	#RsCalendario
set
DiaNome=
case when DiaSemana=1 then
	'Domingo'
when DiaSemana=2 then
	'Segunda'
when DiaSemana=3 then
	'Terca'
when DiaSemana=4 then
	'Quarta'
when DiaSemana=5 then
	'Quinta'
when DiaSemana=6 then
	'Sexta'
when DiaSemana=7 then
	'Sabado'
end

UPDATE
	M
SET 
	M.MES_MOVIMENTO=C.MES,
	M.ANO_MOVIMENTO=C.ANO,
	M.TRIMESTRE_MOVIMENTO=C.TRIMESTRE,
	M.SEMANA_MOVIMENTO=0,
	M.DIA_SEMANA_MOVIMENTO=C.DIASEMANA,
	M.DIA_MOVIMENTO=C.DIA,
	M.DIA_NOME_MOVIMENTO=C.DIANOME,
	M.ANO_SEMANA_MOVIMENTO=C.ANOSEMANA
from
#RsCalendario C inner join GLB_DT_MOVIMENTO M on
C.DT = M.DT_MOVIMENTO

INSERT INTO GLB_DT_MOVIMENTO
(DT_MOVIMENTO,
MES_MOVIMENTO,
ANO_MOVIMENTO,
TRIMESTRE_MOVIMENTO,
SEMANA_MOVIMENTO,
DIA_MOVIMENTO,
DIA_NOME_MOVIMENTO,
ANO_SEMANA_MOVIMENTO,
DIA_SEMANA_MOVIMENTO)
select
	dt,
	mes,
	ano,
	trimestre,
	DATEPART(WK, dt) - DATEPART(WK, dt - DAY(dt) + 1) + 1,
	Dia,
	DiaNome,
	AnoSemana,
	DiaSemana
from
	#RsCalendario C left outer join  GLB_DT_MOVIMENTO m   on
	C.DT  = M.DT_MOVIMENTO  
where
	 M.DT_MOVIMENTO  is null

drop table #RsCalendario
